//
// Copyright (c) 2002
// Ronald Kevin Burton
//
// Z poniszym kodem nie jest zwizana adna gwarancja poprawnoci dziaania.
// Program zosta doczony do ksiki ".NET CLR. Ksiga eksperta" w celu
// ilustracji koncepcji i zasad przedstawionych w tej ksice. Program moe by 
// uywany na wasne ryzyko.
//
// Przyznaje si prawo do uycia lub kopiowania tego oprogramowania do dowolnego celu
// bez koniecznoci ponoszenia adnych opat pod warunkiem, e powysze uwagi zostan 
// zachowane we wszystkich kopiach. Przyznaje si take prawo do modyfikacji kodu
// i dystrybucji zmodyfikowanego kodu pod warunkiem zachowania powyszych uwag
// oraz doczenia informacji mwicej o modyfikacji kodu.
//
//   
using System;
using System.Reflection;

namespace DelegatesAndEvents
{
	class DelegateClass
	{
		public void HelloWorldProcessor(string message)
		{
			Console.WriteLine("DelegateClass: {0}", message);
		}
		public void A(string message)
		{
			Console.WriteLine("A: {0}", message);
		}
		public void B(string message)
		{
			Console.WriteLine("B: {0}", message);
		}
		public void C(string message)
		{
			Console.WriteLine("C: {0}", message);
		}
	}
	class HelloWorld
	{
		// static private int HelloWorldProcessor(string message)
		static private void HelloWorldProcessor(string message)
		{
			Console.WriteLine(message);
		}
		public delegate void HelloWorldDelegate(string message);
		static void Main(string[] args)
		{
			HelloWorldDelegate d = new HelloWorldDelegate(HelloWorldProcessor);
			d("Witaj wiecie!");

			Console.WriteLine("Metoda: {0}", d.Method);
			Console.WriteLine("Cel: {0}", d.Target);

			DelegateClass dc = new DelegateClass();
			d = new HelloWorldDelegate(dc.HelloWorldProcessor);
			d("Witaj wiecie!");
			IAsyncResult ar = d.BeginInvoke("Wywoano Witaj wiecie!", null, null);

			Console.WriteLine("Method: {0}", d.Method);
			Console.WriteLine("Target: {0}", d.Target);

			d.EndInvoke(ar);

			d = new HelloWorldDelegate(HelloWorldProcessor);
			d += new HelloWorldDelegate(dc.HelloWorldProcessor);
			d += new HelloWorldDelegate(dc.A);
			d += new HelloWorldDelegate(dc.B);
			d += new HelloWorldDelegate(dc.C);
			d("Witaj wiecie! z wielokrotnym rzutowaniem");

			Console.WriteLine("Metoda: {0}", d.Method);
			Console.WriteLine("Cel: {0}", d.Target);

			Delegate [] list = d.GetInvocationList();
			foreach(Delegate item in list)
			{
				Console.WriteLine("Metoda: {0}", item.Method);
				Console.WriteLine("Cel: {0}", item.Target);
			}

			Type t = dc.GetType();
			MethodInfo mi = t.GetMethod("HelloWorldProcessor");
			ParameterInfo[] pia = mi.GetParameters();
			foreach(ParameterInfo pi in pia)
			{
				Console.WriteLine(pi.ParameterType);
			}

			d = (HelloWorldDelegate)Delegate.CreateDelegate(typeof(HelloWorldDelegate), dc, "HelloWorldProcessor"); 
			d.DynamicInvoke(new object [] {"Witaj wiecie! z pnym wizaniem"});
			d = (HelloWorldDelegate)Delegate.CreateDelegate(typeof(HelloWorldDelegate), typeof(HelloWorld), "HelloWorldProcessor"); 
			d.DynamicInvoke(new object [] {"Statyczne Witaj wiecie! z pnym wizaniem"});

		}
	}
}
